	function info = treecomplexity(bitspec)
	%info = treecomplexity(bitspec)
	%
	%Calculates complexity of partial product generation, reduction tree and
	%VMA.
	%
	%Arguments:
	%  bitspec - specification structure
	%
	%Returns:
	%  info - structure with complexity information
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	pptype = bitspec.branches{1}.ppmap.type;
	
	info.wout = bitspec.arith.wout;
	info.numout = bitspec.numout;
	info.ppfa = 0;
	info.ppha = 0;
	info.ppregs = 0;
	info.csfa = 0;
	info.csha = 0;
	info.csregs = 0;
	info.vmafa = 0;
	info.vmaha = 0;
	info.vmaregs = 0;
	
	for b = 1:bitspec.numout
		info.branches{b}.ppfa = 0;
		info.branches{b}.ppha = 0;
		info.branches{b}.ppregs = 0;
	end
	
	if strcmp(pptype, 'DF')
		delays = zeros(1, bitspec.numin);
	
		for b = 1:bitspec.numout
			info.branches{b}.ppregs = bitspec.arith.wdata*sum(bitspec.branches{b}.ppmap.delays);
			delays = max(delays, bitspec.branches{b}.ppmap.delays);
		end
	
		info.ppregs = bitspec.arith.wdata*sum(delays);
	end
	
	for b = 1:bitspec.numout
		branch = bitspec.branches{b};
	
		info.branches{b}.csfa = sum(sum(branch.csspec.fa));
		info.branches{b}.csha = sum(sum(branch.csspec.ha));
		info.branches{b}.csregs = sum(sum(branch.csspec.regs));
	
		info.branches{b}.vmafa = sum(sum(branch.vmaspec.fa));
		info.branches{b}.vmaha = sum(sum(branch.vmaspec.ha));
		info.branches{b}.vmaregs = sum(sum(branch.vmaspec.regs));
	
		info.csfa = info.csfa + sum(sum(branch.csspec.fa));
		info.csha = info.csha + sum(sum(branch.csspec.ha));
		info.csregs = info.csregs + sum(sum(branch.csspec.regs));
	
		info.vmafa = info.vmafa + sum(sum(branch.vmaspec.fa));
		info.vmaha = info.vmaha + sum(sum(branch.vmaspec.ha));
		info.vmaregs = info.vmaregs + sum(sum(branch.vmaspec.regs));
	
		info.branches{b}.pipedelay = branch.pipedelay;
	end
	
	if isfield(bitspec, 'shared')
		info.sha.fa = size(bitspec.shared, 1);
		if isempty(bitspec.shared)
			info.sha.regs = 0;
		else
			info.sha.regs = 2*sum(bitspec.shared(:,end));
		end
	else
		info.sha.fa = 0;
		info.sha.regs = 0;
	end
	
